import React from "react";

const Banner = ({ theme }) => {
  const themes = {
    floral: {
      image: "/royalty_free_photos/floral/blossom blush jantemmel.jpg",
      alt: "Wisteria blossoms in soft blush",
      style: "bg-pink-100 text-purple-900",
      heading: "A Garden in Bloom",
      subtext: "Gentle petals, sun-warmed blossoms, and the scent of quiet joy."
    },
    modern_cafe: {
      image: "/royalty_free_photos/modern_cafe/bourbon.jpg",
      alt: "Modern cafe with glinting glasses",
      style: "bg-stone-900 text-white",
      heading: "Espresso & Elegance",
      subtext: "High-end design and the rich scent of brewing coffee."
    },
    cozy_cafe: {
      image: "/royalty_free_photos/cozy_cafe/aerial community brunch.jpeg",
      alt: "Cozy cafe with firewood and community table",
      style: "bg-amber-100 text-brown-900",
      heading: "Warmth & Whispers",
      subtext: "Firewood in the corner, stories shared over tea."
    },
    dusky_natural: {
      image: "/royalty_free_photos/dusky_natural/blue red cabin.png",
      alt: "Twilight cabin under a dusky sky",
      style: "bg-blue-900 text-indigo-100",
      heading: "Twilight Reverie",
      subtext: "Where the dusk holds you and stars begin to hum."
    }
  };

  const selected = themes[theme];

  return (
    <div className={`w-full p-8 rounded-2xl shadow-md flex flex-col items-center justify-center ${selected.style}`}>
      <img src={selected.image} alt={selected.alt} className="w-full max-h-64 object-cover rounded-xl mb-4" />
      <h1 className="text-3xl font-bold mb-2">{selected.heading}</h1>
      <p className="text-lg italic text-center max-w-xl">{selected.subtext}</p>
    </div>
  );
};

export default Banner;